/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class NimRODTextFieldUI
extends BasicTextFieldUI {
    private boolean rollover = false;
    private boolean focus = false;
    private MiTextML miTextML;
    protected boolean oldOpaque;
    protected boolean canijo;

    NimRODTextFieldUI(JComponent jComponent) {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new NimRODTextFieldUI(jComponent);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.oldOpaque = this.getComponent().isOpaque();
        this.getComponent().setOpaque(false);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.getComponent().setOpaque(this.oldOpaque);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.miTextML = new MiTextML();
        this.getComponent().addMouseListener(this.miTextML);
        this.getComponent().addFocusListener(this.miTextML);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeMouseListener(this.miTextML);
        this.getComponent().removeFocusListener(this.miTextML);
    }

    public boolean isFocus() {
        return this.focus;
    }

    public boolean isRollover() {
        return this.rollover;
    }

    @Override
    protected void paintSafely(Graphics graphics) {
        this.paintFocus(graphics);
        this.paintTodo(graphics);
        super.paintSafely(graphics);
    }

    protected void paintTodo(Graphics graphics) {
        JTextComponent jTextComponent = this.getComponent();
        Border border = jTextComponent.getBorder();
        if (border != null && border instanceof NimRODBorders.NimRODGenBorder) {
            Insets insets = NimRODBorders.getTextFieldBorder().getBorderInsets(jTextComponent);
            if (jTextComponent.getSize().height + 2 < jTextComponent.getFont().getSize() + insets.top + insets.bottom) {
                jTextComponent.setBorder(NimRODBorders.getThinGenBorder());
                this.canijo = true;
            } else {
                jTextComponent.setBorder(NimRODBorders.getTextFieldBorder());
                this.canijo = false;
            }
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                graphics.setColor(UIManager.getColor("TextField.inactiveBackground"));
            } else {
                graphics.setColor(jTextComponent.getBackground());
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.fillRoundRect(2, 2, jTextComponent.getWidth() - 4, jTextComponent.getHeight() - 4, 7, 7);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        } else {
            super.paintBackground(graphics);
        }
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        JTextComponent jTextComponent = this.getComponent();
        graphics.setColor(jTextComponent.getBackground());
        graphics.fillRect(0, 0, jTextComponent.getWidth(), jTextComponent.getHeight());
        System.out.println("toy");
    }

    protected void paintFocus(Graphics graphics) {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent.isEnabled() && jTextComponent.isEditable() && !this.canijo) {
            if (this.focus) {
                NimRODUtils.paintFocus(graphics, 1, 1, jTextComponent.getWidth() - 2, jTextComponent.getHeight() - 2, 4, 4, 3.0f, NimRODLookAndFeel.getFocusColor());
            } else if (this.rollover) {
                NimRODUtils.paintFocus(graphics, 1, 1, jTextComponent.getWidth() - 2, jTextComponent.getHeight() - 2, 4, 4, 3.0f, NimRODUtils.getColorAlfa(NimRODLookAndFeel.getFocusColor(), 150));
            }
        }
    }

    class MiTextML
    extends MouseAdapter
    implements FocusListener {
        MiTextML() {
        }

        protected void refresh() {
            if (NimRODTextFieldUI.this.getComponent().getParent() != null) {
                JTextComponent jTextComponent = NimRODTextFieldUI.this.getComponent();
                jTextComponent.getParent().repaint(((Component)jTextComponent).getX() - 5, ((Component)jTextComponent).getY() - 5, ((Component)jTextComponent).getWidth() + 10, ((Component)jTextComponent).getHeight() + 10);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            NimRODTextFieldUI.this.rollover = false;
            this.refresh();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            NimRODTextFieldUI.this.rollover = true;
            this.refresh();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            NimRODTextFieldUI.this.focus = true;
            this.refresh();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            NimRODTextFieldUI.this.focus = false;
            this.refresh();
        }
    }
}

